float2 R;
float Time;
float2 MoveSpeed=(3.1246,5.6147);
float RotateSpeed=2.351235;
float ZoomSpeed=1;

float2 MoveAmplify=1;
float RotateAmplify=1;
float ZoomAmplify=1;
float2 MoveOffset=0;
float RotateOffset=0;
float ZoomOffset=0;
float Blur=0;
float MotionBlur;
#define T (Time*acos(-1)*2)
bool Aspect;

texture tex0;
sampler s0=sampler_state{Texture=(tex0);MipFilter=LINEAR;MinFilter=LINEAR;MagFilter=LINEAR;};
sampler s1=sampler_state{Texture=(tex0);MipFilter=POINT;MinFilter=POINT;MagFilter=POINT;};

float2 r2d(float2 x,float a){a*=acos(-1)*2;return float2(cos(a)*x.x+sin(a)*x.y,cos(a)*x.y-sin(a)*x.x);}

float4 p0(float2 x:TEXCOORD0,float Time:TEXCOORD1):color{float2 asp=lerp(1,R.x/R,Aspect);
    float2 vp=x*R-.25;
	float2 off=sin(Time*MoveSpeed)*MoveAmplify+MoveOffset;
	float rot=sin(T*RotateSpeed)*RotateAmplify+RotateOffset;
	float zoom=sin(T*ZoomSpeed)*ZoomAmplify+ZoomOffset;
    float2 dx=r2d((x-.5-off)/asp,rot)*pow(2,zoom)*asp+.5;
    float4 c=tex2Dlod(s0,float4(dx,0,Blur*log2(max(R.x,R.y))));
    return c;
}
float4 p1(float2 x:TEXCOORD0,float2 vp:VPOS):color{float2 asp=lerp(1,R.x/R,Aspect);
	float4 c=0;
	for(float i=0;i<8;i++){
		c+=p0(x,Time+i*MotionBlur*.001)/8.;
	}
    return c;
}
void vs2d(inout float4 vp:POSITION0,inout float2 uv:TEXCOORD0){vp.xy*=2;uv+=.5/R;}
technique Mirror{pass pp0{AddressU[0]=MIRROR;AddressV[0]=MIRROR;AddressU[1]=MIRROR;AddressV[1]=MIRROR;vertexshader=compile vs_3_0 vs2d();pixelshader=compile ps_3_0 p1();}}
technique Wrap{pass pp0{AddressU[0]=WRAP;AddressV[0]=WRAP;AddressU[1]=WRAP;AddressV[1]=WRAP;vertexshader=compile vs_3_0 vs2d();pixelshader=compile ps_3_0 p1();}}
